package ru.yandex.stockpile.server.shard.merge;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class OneItemIterator implements Iterator {
    private final Item item;
    private final MetricType type;
    private final int columnSetMask;
    private final int elapsedRecords;
    private boolean end;

    public OneItemIterator(Item item, MetricType type, int columnSetMask, int elapsedRecords) {
        this.item = item;
        this.type = type;
        this.columnSetMask = columnSetMask;
        this.elapsedRecords = elapsedRecords;
    }

    public static Iterator of(AggrGraphDataListIterator it, MetricType type, long firstTsMillis, long lastTsMillis, int elapsedBytes) {
        var item = new ItemIterator(it, firstTsMillis, lastTsMillis, elapsedBytes);
        return new OneItemIterator(item, type, it.columnSetMask(), it.estimatePointsCount());
    }

    @Override
    public MetricType type() {
        return type;
    }

    @Override
    public int columnSetMask() {
        return columnSetMask;
    }

    @Override
    public int elapsedRecords() {
        return elapsedRecords;
    }

    @Nullable
    @Override
    public Item next() {
        if (end) {
            return null;
        }
        end = true;
        return item;
    }
}
