package ru.yandex.stockpile.server.shard.stat;

/**
 * @author Stepan Koltsov
 */
public record LevelSizeAndCount(SizeAndCount index, SizeAndCount chunk, SizeAndCount command) {
    public static final LevelSizeAndCount zero = new LevelSizeAndCount(SizeAndCount.zero, SizeAndCount.zero, SizeAndCount.zero);

    public static LevelSizeAndCount plus(LevelSizeAndCount left, LevelSizeAndCount right) {
        return new LevelSizeAndCount(
                SizeAndCount.plus(left.index, right.index),
                SizeAndCount.plus(left.chunk, right.chunk),
                SizeAndCount.plus(left.command, right.command)
        );
    }

    public static LevelSizeAndCount minus(LevelSizeAndCount left, LevelSizeAndCount right) {
        return new LevelSizeAndCount(
                SizeAndCount.minus(left.index, right.index),
                SizeAndCount.minus(left.chunk, right.chunk),
                SizeAndCount.minus(left.command, right.command)
        );
    }
}
