package ru.yandex.stockpile.server.shard.stat;

import javax.annotation.Nonnull;

/**
 * @author Stepan Koltsov
 */
public record SizeAndCount(long size, int count) {
    public static final SizeAndCount zero = new SizeAndCount(0, 0);

    public boolean isEmpty() {
        return count == 0;
    }

    @Nonnull
    public static SizeAndCount plus(SizeAndCount a, SizeAndCount b) {
        return new SizeAndCount(a.size() + b.size(), a.count() + b.count());
    }

    @Nonnull
    public static SizeAndCount minus(SizeAndCount a, SizeAndCount b) {
        return new SizeAndCount(a.size() - b.size(), a.count() - b.count());
    }
}
