package ru.yandex.stockpile.server.shard.stat;

import java.util.EnumMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.EnumMapUtils;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.names.FileKind;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileShardDiskStats {


    private final EnumMap<FileKind, SizeAndCount> map;


    public StockpileShardDiskStats(
        SizeAndCount logsSize,
        EnumMap<SnapshotLevel, LevelSizeAndCount> byLevel)
    {
        map = EnumMapUtils.consts(FileKind.class, SizeAndCount.zero);
        map.put(FileKind.LOG, logsSize);
        for (Map.Entry<SnapshotLevel, LevelSizeAndCount> e : byLevel.entrySet()) {
            SnapshotLevel level = e.getKey();
            LevelSizeAndCount levelSizeAndCount = e.getValue();
            map.put(level.index.kind(), levelSizeAndCount.index());
            map.put(level.chunk.kind(), levelSizeAndCount.chunk());
            map.put(level.command.kind(), levelSizeAndCount.command());
        }
    }

    public StockpileShardDiskStats() {
        map = EnumMapUtils.consts(FileKind.class, new SizeAndCount(0, 0));
    }

    public StockpileShardDiskStats(EnumMap<FileKind, SizeAndCount> map) {
        this.map = EnumMapUtils.consts(FileKind.class, new SizeAndCount(0, 0));
        this.map.putAll(map);
    }

    @Nonnull
    public static StockpileShardDiskStats zeroes() {
        return new StockpileShardDiskStats(
                SizeAndCount.zero,
                new EnumMap<>(SnapshotLevel.class));
    }

    public SizeAndCount get(FileKind kind) {
        return map.get(kind);
    }

    public static StockpileShardDiskStats add(StockpileShardDiskStats a, StockpileShardDiskStats b) {
        return new StockpileShardDiskStats(EnumMapUtils.fill(FileKind.class, e -> SizeAndCount.plus(a.map.get(e), b.map.get(e))));
    }
}
