package ru.yandex.stockpile.server.shard.stat;

import ru.yandex.solomon.staffOnly.manager.special.DurationMillis;
import ru.yandex.solomon.staffOnly.manager.special.InstantMillis;
import ru.yandex.solomon.staffOnly.manager.table.TableColumn;
import ru.yandex.stockpile.server.shard.StockpileShardMetrics;

/**
 * @author Stepan Koltsov
 */
public class StockpileShardStats {

    @DurationMillis
    public long loadDurationMillis;

    @InstantMillis
    public long startMillis = System.currentTimeMillis();
    public long writeLogSnapshots = 0;

    private StockpileShardMetrics metrics;

    public StockpileShardStats(StockpileShardMetrics metrics) {
        this.metrics = metrics;
    }

    @TableColumn
    public float actRatio() {
        return 1.0f * metrics.act.time.get() / (System.currentTimeMillis() - startMillis);
    }

    @TableColumn
    public float actPerSecond() {
        return 1000.f * metrics.act.count.get() / (System.currentTimeMillis() - startMillis);
    }

    @TableColumn
    public float writeTxsPerSecond() {
        return 1000.f * metrics.write.txs.get() / (System.currentTimeMillis() - startMillis);
    }

    @TableColumn
    public float writeRecordsPerSecond() {
        return 1000.f * metrics.write.records.get() / (System.currentTimeMillis() - startMillis);
    }
}
