package ru.yandex.stockpile.server.shard.stat;

import java.util.Collection;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;

/**
 * @author Vladimir Gordiychuk
 */
@SuppressWarnings("ProtocolBufferOrdinal")
public class TxWriteStats {

    // assume that tx write contain count records and metrics less that Integer.MAX_VALUE
    final Long2ObjectOpenHashMap<UsageMetric> summary;

    public TxWriteStats() {
        this.summary = new Long2ObjectOpenHashMap<>();
    }

    public static TxWriteStats of(Collection<MetricArchiveMutable> archives) {
        var result = new TxWriteStats();
        result.addAll(archives);
        return result;
    }

    public void add(MetricArchiveMutable archive) {
        long key = UsageKey.key(archive.getOwnerProjectId(), archive.getType().ordinal(), archive.getOwnerShardId());
        var usageMetric = summary.get(key);
        if (usageMetric == null) {
            usageMetric = new UsageMetric();
            summary.put(key, usageMetric);
        }
        usageMetric.add(archive.getRecordCount(), archive.getLastTsMillis());
    }

    public void addAll(Collection<MetricArchiveMutable> archives) {
        for (var archive : archives) {
            add(archive);
        }
    }

    static final class UsageMetric {
        private final Long2LongOpenHashMap lastTs2Count = new Long2LongOpenHashMap();
        private int points;
        private int metricsCount;

        public void add(long pointsCount, long lastTsMillis) {
            ++metricsCount;
            this.points += pointsCount;
            lastTs2Count.addTo(lastTsMillis, 1L);
        }

        public long getPoints() {
            return points;
        }

        public long getMetricsCount() {
            return metricsCount;
        }

        public Long2LongOpenHashMap getLastTs2Count() {
            return lastTs2Count;
        }
    }
}
