package ru.yandex.stockpile.server.shard.stat;

/**
 * @author Vladimir Gordiychuk
 */
public final class UsageKey {
    private UsageKey() {
    }

    public static long key(int projectId, int type, int ownerShardId) {
        return key(projectId, 0, type, ownerShardId);
    }

    public static long key(int projectId, int producer, int type, int ownerShardId) {
        // 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
        // 1111 1111 1111 1111 1111 1111 1111 1111 0000 0000 0000 0000 0000 0000 0000 0000 shardId
        // 0000 0000 0000 0000 0000 0000 0000 0000 1111 1111 0000 0000 0000 0000 0000 0000 projectId
        // 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 1111 1111 0000 0000 0000 0000 producer
        // 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 1111 1111 1111 1111 type
        long result = (long) ownerShardId << 32;
        result |= (long) projectId << 24;
        result |= (long) producer << 16;
        result |= (long) type;
        return result;
    }

    public static int project(long key) {
        return (int) ((key & 0xff000000L) >> 24);
    }

    public static int producer(long key) {
        return (int) ((key & 0xff0000L) >> 16);
    }

    public static int type(long key) {
        return (int) (key & 0xffffL);
    }

    public static int shardId(long key) {
        return (int) (key >> 32);
    }
}
