package ru.yandex.stockpile.tool;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

import ru.yandex.solomon.selfmon.failsafe.RateLimiter;
import ru.yandex.solomon.selfmon.failsafe.TokenBucketRateLimiter;

/**
 * @author Vladimir Gordiychuk
 */
public class Sampler {
    private final RateLimiter limiter;
    private final double sampling;

    public Sampler(double sampling, int permitPerSec) {
        this.limiter = new TokenBucketRateLimiter(Clock.systemUTC(), permitPerSec, Duration.ofSeconds(1));
        this.sampling = sampling;
    }

    public boolean acquire() {
        if (sampling < 1.0 && ThreadLocalRandom.current().nextDouble() >= sampling) {
            return false;
        }

        return limiter.acquire();
    }

}
