package ru.yandex.stockpile.tool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import com.google.common.net.HostAndPort;

import ru.yandex.grpc.utils.DefaultClientOptions;
import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.solomon.util.PropertyInitializer;
import ru.yandex.solomon.util.future.RetryCompletableFuture;
import ru.yandex.solomon.util.future.RetryConfig;
import ru.yandex.solomon.util.host.HostUtils;
import ru.yandex.stockpile.internal.tool.StockpileToolsServiceGrpc;
import ru.yandex.stockpile.internal.tool.TForceLogSnapshotRequest;
import ru.yandex.stockpile.internal.tool.TForceLogSnapshotResponse;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileForceLogSnapshot {

    static {
        PropertyInitializer.init();
    }

    public static void main(String[] args) {
        int max = args.length == 1 ? Integer.parseInt(args[0]) : 100;
        try (var transport = makeTransport()) {
            var req = TForceLogSnapshotRequest.newBuilder()
                    .setMinLogMegabytesSize(100)
                    .setMaxInFlight(max)
                    .build();
            snapshot(transport, req).join();
        } catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static CompletableFuture<TForceLogSnapshotResponse> snapshot(GrpcTransport transport, TForceLogSnapshotRequest req) {
        var conf = RetryConfig.DEFAULT.withNumRetries(3).withDelay(5_000);
        return RetryCompletableFuture.runWithRetries(() -> transport.unaryCall(StockpileToolsServiceGrpc.getForceLogsSnapshotMethod(), req), conf);
    }

    private static GrpcTransport makeTransport() {
        var address = HostAndPort.fromParts(HostUtils.getFqdn(), 4700);
        var opts = DefaultClientOptions.newBuilder()
                .setClientId("snapshot-logs")
                .setRequestTimeOut(5, TimeUnit.MINUTES)
                .build();

        return new GrpcTransport(address, opts);
    }
}
