package ru.yandex.stockpile.tool;

import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.stockpile.server.shard.StockpileExecutor;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.tool.server.StockpileToolServiceGrpc;

/**
 * @author Vladimir Gordiychuk
 */
@Import({
    StockpileLocalShards.class
})
@Configuration
public class StockpileToolContext {

    @Bean
    public StockpileToolServiceGrpc stockpileToolServiceGrpc(
        StockpileLocalShards localShards,
        @StockpileExecutor ExecutorService executor)
    {
        return new StockpileToolServiceGrpc(localShards, executor);
    }

    @Bean
    public StockpileToolServiceGrpc.Proxy stockpileToolServiceGrpcProxy(StockpileToolServiceGrpc service) {
        return new StockpileToolServiceGrpc.Proxy(service);
    }

}
