package ru.yandex.stockpile.api.grpc;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Message;
import org.junit.Test;

import ru.yandex.solomon.model.protobuf.HistogramConverter;
import ru.yandex.solomon.model.type.Histogram;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomHist;

/**
 * @author Vladimir Gordiychuk
 */
public class HistogramParserTest {
    @Test
    public void parse() {
        var random = ThreadLocalRandom.current();
        for (int index = 0; index < 10; index++) {
            var expected = randomHist(random);
            var proto = HistogramConverter.toProto(expected);

            var parsed = serializeAndParse(proto);
            assertEquals(expected, parsed);
        }
    }

    @Test
    public void histWithNegativeBounds() {
        var proto = ru.yandex.solomon.model.protobuf.Histogram.newBuilder()
            .addAllBounds(List.of(-1.0, 0.0, 1.0, 2.0, 3.0))
            .addAllBuckets(List.of(1L, 2L, 1L, 1L, 1L))
            .build();

        var parsed = serializeAndParse(proto);
        var expected = Histogram.newInstance(
            new double[]{-1.0, 0.0, 1.0, 2.0, 3.0},
            new long[]{1L, 2L, 1L, 1L, 1L});

        assertEquals(expected, parsed);
    }

    private Histogram serializeAndParse(Message proto) {
        byte[] serialized = proto.toByteArray();
        return HistogramParser.parse(CodedInputStream.newInstance(serialized));
    }

}
