package ru.yandex.stockpile.api.grpc;

import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.CodedInputStream;
import org.junit.Test;

import ru.yandex.solomon.model.protobuf.LogHistogramConverter;
import ru.yandex.solomon.model.type.LogHistogram;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomLogHist;

/**
 * @author Vladimir Gordiychuk
 */
public class LogHistogramParserTest {

    @Test
    public void parse() {
        var random = ThreadLocalRandom.current();
        for (int index = 0; index < 10; index++) {
            var expected = randomLogHist(random);
            var proto = LogHistogramConverter.toProto(expected);

            var parsed = serializeAndParse(proto);
            assertEquals(expected, parsed);
        }
    }

    private LogHistogram serializeAndParse(ru.yandex.solomon.model.protobuf.LogHistogram proto) {
        byte[] serialized = proto.toByteArray();
        return LogHistogramParser.parse(CodedInputStream.newInstance(serialized));
    }

}
