package ru.yandex.stockpile.api.grpc;

import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.CodedInputStream;
import org.junit.Test;

import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.model.protobuf.SummaryConverter;
import ru.yandex.solomon.model.protobuf.SummaryDouble;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomDSummary;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryDoubleParserTest {

    @Test
    public void parse() {
        var random = ThreadLocalRandom.current();
        for (int index = 0; index < 10; index++) {
            var expected = randomDSummary(random);
            var proto = SummaryConverter.toProto(expected);

            var parsed = serializeAndParse(proto);
            assertEquals(expected, parsed);
        }
    }

    @Test
    public void parseZeros() {
        SummaryDouble summary = SummaryDouble.newBuilder()
            .setCount(1)
            .setLast(0)
            .setMin(0)
            .setMax(0)
            .build();

        SummaryDoubleSnapshot value = serializeAndParse(summary);
        assertEquals(0, value.getLast(), 0);
        assertEquals(0, value.getMin(), 0);
        assertEquals(0, value.getMax(), 0);
        assertEquals(1, value.getCount());
    }

    private SummaryDoubleSnapshot serializeAndParse(SummaryDouble proto) {
        byte[] serialized = proto.toByteArray();
        return SummaryDoubleParser.parse(CodedInputStream.newInstance(serialized));
    }
}
