package ru.yandex.stockpile.api.grpc;

import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Message;
import org.junit.Test;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.protobuf.SummaryConverter;
import ru.yandex.solomon.model.protobuf.SummaryInt64;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomISummary;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64ParserTest {
    @Test
    public void parse() {
        var random = ThreadLocalRandom.current();
        for (int index = 0; index < 10; index++) {
            var expected = randomISummary(random);
            var proto = SummaryConverter.toProto(expected);

            var parsed = serializeAndParse(proto);
            assertEquals(expected, parsed);
        }
    }

    @Test
    public void parseZeros() {
        SummaryInt64 summary = SummaryInt64.newBuilder()
            .setCount(1)
            .setLast(0)
            .setMin(0)
            .setMax(0)
            .build();

        var value = serializeAndParse(summary);
        assertEquals(0, value.getLast());
        assertEquals(0, value.getMin());
        assertEquals(0, value.getMax());
        assertEquals(1, value.getCount());
    }

    private SummaryInt64Snapshot serializeAndParse(Message proto) {
        byte[] serialized = proto.toByteArray();
        return SummaryInt64Parser.parse(CodedInputStream.newInstance(serialized));
    }
}
