package ru.yandex.stockpile.api.grpc;

import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.CodedInputStream;
import org.junit.Test;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.ValueColumn;
import ru.yandex.solomon.model.protobuf.MetricId;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.api.EProjectId;
import ru.yandex.stockpile.api.TWriteRequest;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomMask;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomMetricType;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;
import static ru.yandex.solomon.util.CloseableUtils.close;

/**
 * @author Vladimir Gordiychuk
 */
public class TWriteRequestParserTest {
    @Test
    public void parse() {
        for (int i = 0; i < 50; i++) {
            MetricType type = randomMetricType();
            int mask = randomMask(type);
            var expected = new MetricArchiveMutable();
            expected.setOwnerProjectIdEnum(EProjectId.GOLOVAN);
            expected.setDecimPolicyId(DecimPolicy.POLICY_5_MIN_AFTER_8_DAYS.toProto().getNumber());
            expected.setType(type);
            expected.setOwnerShardId(ThreadLocalRandom.current().nextInt());
            expected.ensureCapacity(mask, 10);
            for (int j = 0; j < 5; j++) {
                AggrPoint point = randomPoint(mask);
                point.valueDenom = ValueColumn.DEFAULT_DENOM;
                expected.addRecord(point);
            }
            expected.sortAndMerge();

            var parsed = serializeAndParse(expected);
            assertEquals(expected, parsed);
            close(expected, parsed);
        }
    }

    private MetricArchiveMutable serializeAndParse(MetricArchiveMutable archive) {
        long localId = StockpileLocalId.random();
        var request = TWriteRequest.newBuilder()
            .setMetricId(MetricId.newBuilder()
                .setLocalId(localId)
                .build())
            .setType(archive.getType())
            .setColumnMask(archive.columnSetMask())
            .setOwnerShardId(archive.getOwnerShardId());

        AggrPoint point = new AggrPoint();
        var it = archive.iterator();
        while (it.next(point)) {
            request.addPoints(TPointConverters.toProto(archive.columnSetMask(), point));
        }

        byte[] serialized = request.build().toByteArray();

        StockpileWriteRequest.Builder builder = StockpileWriteRequest.newBuilder();
        TWriteRequestParser.parse(builder, point, CodedInputStream.newInstance(serialized));
        return builder.archiveRef(localId);
    }
}
