package ru.yandex.stockpile.cluster.balancer.dao;

import org.junit.After;
import org.junit.Before;

import ru.yandex.kikimr.client.kv.inMem.KikimrKvClientInMem;
import ru.yandex.solomon.balancer.dao.BalancerDao;

/**
 * @author Vladimir Gordiychuk
 */
public class KvStockpileBalancerDaoTest extends StockpileBalancerDaoTest {
    private KikimrKvClientInMem client;
    private KvStockpileBalancerDao dao;

    @Override
    @Before
    public void setUp() {
        client = new KikimrKvClientInMem();
        long tabletId = client.createKvTablet();
        dao = new KvStockpileBalancerDao(client, "/Root/Stockpile/System", tabletId);
        super.setUp();
    }

    @After
    public void tearDown() {
        client.close();
    }

    @Override
    protected BalancerDao getDao() {
        return dao;
    }
}
