package ru.yandex.stockpile.kikimrKv;

import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.kikimr.client.KikimrGrpcTransport;
import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.KikimrKvClientImpl;
import ru.yandex.kikimr.util.KikimrHosts;


/**
 * @author Sergey Polovko
 */
@YaIgnore
@Ignore
public class KvTabletsMappingItTest {

    private ScheduledExecutorService executor;
    private KikimrKvClient kvClient;

    @Before
    public void setUp() {
        executor = Executors.newSingleThreadScheduledExecutor();
        kvClient = new KikimrKvClientImpl(
            new KikimrGrpcTransport(KikimrHosts.TEST, 10 << 20));
    }

    @After
    public void tearDown() throws Exception {
        executor.shutdown();
        Assert.assertTrue(executor.awaitTermination(3, TimeUnit.SECONDS));
    }

    @Test(timeout = 5_000)
    public void tabletsCreatedWithSchemeShard() {
        int shardsCount = 32;
        String kvVolumePath = "/Solomon/" + UUID.randomUUID();
        kvClient.createKvTablets(kvVolumePath, shardsCount).join();

        KvTabletsMapping kvMapping = new KvTabletsMapping(kvVolumePath, kvClient, executor, executor);
        kvMapping.waitForReady();

        for (int shardId = 1; shardId <= shardsCount; shardId++) {
            long tabletId = kvMapping.getTabletId(shardId);
            Assert.assertNotEquals(0, tabletId);
            Assert.assertTrue(kvMapping.hasTabletId(tabletId));
        }
    }
}
