package ru.yandex.stockpile.kikimrKv;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardIdMapToLongTest {

    @Test(expected = IllegalArgumentException.class)
    public void empty() {
        new ShardIdMapToLong(new long[0]);
    }

    @Test
    public void validTabletIds() {
        long[] tabletIds = new long[] {123, 321, 222, 555};
        var map = new ShardIdMapToLong(tabletIds);
        assertEquals(123L, map.get(1));
        assertEquals(321L, map.get(2));
        assertEquals(222L, map.get(3));
        assertEquals(555L, map.get(4));
    }
}
