package ru.yandex.stockpile.kikimrKv.counting;

import io.grpc.Status;
import org.junit.Test;

import ru.yandex.kikimr.client.KikimrAnyResponseException;
import ru.yandex.kikimr.client.ResponseStatus;
import ru.yandex.kikimr.proto.MsgbusKv;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class KikimrKvClientMetricsTest {

    @Test
    public void unknownError() {
        String status = KikimrKvClientMetrics.errorStatusName(new NullPointerException());
        assertEquals("UNKNOWN", status);
    }

    @Test
    public void grpcError() {
        for (Status.Code code : Status.Code.values()) {
            RuntimeException e = new RuntimeException("wrap", Status.fromCode(code).asRuntimeException());
            String status = KikimrKvClientMetrics.errorStatusName(e);
            assertEquals(code.name(), status);
        }
    }

    @Test
    public void kvException() {
        for (ResponseStatus status : ResponseStatus.values()) {
            MsgbusKv.TKeyValueResponse r = MsgbusKv.TKeyValueResponse.newBuilder()
                .setStatus(status.cppValue())
                .build();

            RuntimeException e = new RuntimeException("wrap",  new KikimrAnyResponseException(r, "oops"));
            String result = KikimrKvClientMetrics.errorStatusName(e);
            assertEquals(status.name(), result);
        }
    }
}
