package ru.yandex.stockpile.memState;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.point.column.StockpileColumns;
import ru.yandex.solomon.model.protobuf.MetricType;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricToArchiveMapTest {

    @Test
    public void objectSizeEmpty() {
        MetricToArchiveMap map = new MetricToArchiveMap();
        GraphLayout gl = GraphLayout.parseInstance(map);

        assertEquals(gl.totalSize(), map.memorySizeIncludingSelf());
        map.release();
    }

    @Test
    public void objectSize() {
        MetricToArchiveMap map = new MetricToArchiveMap();
        for (int index = 0; index < 142; index++) {
            MetricArchiveMutable archive = new MetricArchiveMutable();
            archive.setType(MetricType.DGAUGE);
            archive.ensureCapacity(StockpileColumns.minColumnSet(MetricType.DGAUGE), 100);
            archive.addRecord(randomPoint(MetricType.DGAUGE));
            map.addRecordsMultiArchive(index + 1, archive);
        }

        GraphLayout gl = GraphLayout.parseInstance(map);

        // Exclude enums because exists into single instance into app
        long enumSize = GraphLayout.parseInstance(MetricType.DGAUGE, StockpileFormat.CURRENT).totalSize();
        assertEquals(gl.totalSize() - enumSize, map.memorySizeIncludingSelf());
        map.release();
    }
}
