package ru.yandex.stockpile.server;

import org.junit.Test;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static ru.yandex.stockpile.server.SnapshotLevel.DAILY;
import static ru.yandex.stockpile.server.SnapshotLevel.ETERNITY;
import static ru.yandex.stockpile.server.SnapshotLevel.TWO_HOURS;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotLevelTest {

    @Test
    public void nextLevel() {
        assertEquals(DAILY, TWO_HOURS.nextLevel());
        assertEquals(ETERNITY, DAILY.nextLevel());
    }

    @Test
    public void aboveLevels() {
        assertArrayEquals(new SnapshotLevel[]{TWO_HOURS}, TWO_HOURS.currentAndAboveLevels());
        assertArrayEquals(new SnapshotLevel[]{TWO_HOURS, DAILY}, DAILY.currentAndAboveLevels());
        assertArrayEquals(new SnapshotLevel[]{TWO_HOURS, DAILY, ETERNITY}, ETERNITY.currentAndAboveLevels());
    }
}
