package ru.yandex.stockpile.server.cache.intrList;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class IntrusiveListTest {

    private static class Item extends IntrusiveListItem<Item> {
        private final int payload;

        public Item(int payload) {
            this.payload = payload;
        }

        @Override
        public String toString() {
            return Integer.toString(payload);
        }

        @Override
        public long memorySizeIncludingSelf() {
            return 0;
        }
    }

    @Test
    public void test() {
        IntrusiveList<Item> list = new IntrusiveList<>();
        list.checkLinksForTest();
        Assert.assertEquals(List.of(), mapPayload(list));
        list.add(new Item(10));
        list.checkLinksForTest();
        Assert.assertEquals(List.of(10), mapPayload(list));
        list.add(new Item(20));
        list.checkLinksForTest();
        Assert.assertEquals(List.of(10, 20), mapPayload(list));
        list.add(new Item(30));
        list.checkLinksForTest();
        Assert.assertEquals(List.of(10, 20, 30), mapPayload(list));

        list.remove(list.get(1));
        list.checkLinksForTest();
        Assert.assertEquals(List.of(10, 30), mapPayload(list));
        list.remove(list.get(0));
        list.checkLinksForTest();
        Assert.assertEquals(List.of(30), mapPayload(list));
    }

    private static List<Integer> mapPayload(IntrusiveList<Item> list) {
        return list.toList().stream().map(i -> i.payload).collect(Collectors.toList());
    }

    @Test
    public void removeFirst() {
        IntrusiveList<Item> list = new IntrusiveList<>();
        list.add(new Item(10));
        list.add(new Item(20));
        Assert.assertEquals(10, list.removeFirst().payload);
        list.checkLinksForTest();
        Assert.assertEquals(20, list.removeFirst().payload);
        list.checkLinksForTest();
        Assert.assertTrue(list.isEmpty());
        list.checkLinksForTest();
    }

    @Test
    public void random() {
        Random random = new Random(17);

        for (int i = 0; i < 1000; ++i) {
            IntrusiveList<Item> list = new IntrusiveList<>();
            List<Integer> reference = new ArrayList<>();
            for (int j = 0; j < 100; ++j) {
                boolean insert = random.nextBoolean();
                if (insert) {
                    int pos = random.nextInt(reference.size() + 1);
                    int value = random.nextInt(100000) + 100000;
                    reference.add(pos, value);
                    list.add(pos, new Item(value));
                } else {
                    if (list.isEmpty()) {
                        continue;
                    }

                    int pos = random.nextInt(reference.size());
                    reference.remove(pos);
                    list.removeAt(pos);
                }

                list.checkLinksForTest();
                Assert.assertEquals(reference, list.iterator().map(x -> x.payload).toList());
            }
        }
    }

}
