package ru.yandex.stockpile.server.cache.lhm;

import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.memory.layout.MemMeasurable;

import static org.junit.Assert.assertEquals;

/**
 * @author Stepan Koltsov
 */
public class Long2ObjectLinkedHashMap2Test {

    @Test
    public void test() {
        Long2ObjectLinkedHashMap<Integer> m = new Long2ObjectLinkedHashMap<>();

        Assert.assertNull(m.get(1));
        Assert.assertNull(m.getAndRefresh(1));
        assertEquals(20, (int) m.getAndRefreshOrCreate(1, () -> 20));

        assertEquals(20, (int) m.getAndRefreshOrCreate(1, () -> 30));

        assertEquals(40, (int) m.getAndRefreshOrCreate(2, () -> 40));

        System.out.println(m);

        assertEquals(20, (int) m.removeOldest());
    }

    @Test
    public void testToString() {
        Long2ObjectLinkedHashMap<Integer> m = new Long2ObjectLinkedHashMap<>();
        m.put(1, 10);
        m.put(2, 20);
        m.put(3, 30);
        assertEquals("{1=10, 2=20, 3=30}", m.toString());
    }

    @Test
    public void remove() {
        Long2ObjectLinkedHashMap<Integer> m = new Long2ObjectLinkedHashMap<>();
        m.put(1, 10);

        Assert.assertNull(m.remove(3));

        m.put(2, 20);
        m.checkForTest();

        assertEquals((Integer) 10, m.remove(1));
        m.checkForTest();

        assertEquals((Integer) 20, m.remove(2));
        m.checkForTest();

        Assert.assertTrue(m.isEmpty());
    }

    @Test
    public void objectSizeEmpty() {
        Long2ObjectLinkedHashMap<Integer> source = new Long2ObjectLinkedHashMap<>();
        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf());
    }

    @Test
    public void objectSize() {
        Long2ObjectLinkedHashMap<Integer> source = new Long2ObjectLinkedHashMap<>();
        for (int index = 0; index < 100; index++) {
            source.put(index, null);
        }

        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf());
    }

    private long expectedLayout(MemMeasurable source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        return gl.totalSize();
    }
}
