package ru.yandex.stockpile.server.data;

import java.util.concurrent.ThreadLocalRandom;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.codec.serializer.StockpileFormat;

import static org.junit.Assert.assertEquals;
import static org.junit.Assume.assumeTrue;

/**
 * @author Vladimir Gordiychuk
 */
@RunWith(Parameterized.class)
public class DeletedShardSetSerializerTest {
    @Parameterized.Parameter
    public StockpileFormat format;

    @Parameterized.Parameters(name = "{0}")
    public static Object[] data() {
        return StockpileFormat.values();
    }

    @Before
    public void setUp() throws Exception {
        assumeTrue("Unsupported format", format.ge(StockpileFormat.DELETED_SHARDS_39));
    }

    @Test
    public void serializeDeserializeEmpty() {
        DeletedShardSet expected = new DeletedShardSet();
        var actual = deserialize(serialize(expected));
        assertEquals(expected, actual);
    }

    @Test
    public void serializeDeserialize() {
        var size = ThreadLocalRandom.current().nextInt(1000);
        DeletedShardSet expected = new DeletedShardSet(size);
        for (int index = 0; index < size; index++) {
            int projectId = ThreadLocalRandom.current().nextInt(3);
            int shardId = ThreadLocalRandom.current().nextInt();
            expected.add(projectId, shardId);
        }

        var actual = deserialize(serialize(expected));
        assertEquals(expected, actual);
    }

    public byte[] serialize(DeletedShardSet deletedShards) {
        return DeletedShardSetSerializer.serializerForFormat(format).serializeToBytes(deletedShards);
    }

    private DeletedShardSet deserialize(byte[] serialized) {
        return DeletedShardSetSerializer.serializerForFormat(format).deserializeFull(serialized);
    }
}
