package ru.yandex.stockpile.server.data;

import java.util.concurrent.ThreadLocalRandom;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class DeletedShardSetTest {

    @Test
    public void packUnpackKey() {
        for (int index = 0; index < 10; index++) {
            int projectId = ThreadLocalRandom.current().nextInt();
            int shardId = ThreadLocalRandom.current().nextInt();

            long key = DeletedShardSet.key(projectId, shardId);
            assertEquals("project", projectId, DeletedShardSet.projectId(key));
            assertEquals("shard", shardId, DeletedShardSet.shardId(key));
        }
    }

    @Test
    public void addContains() {
        int projectId = ThreadLocalRandom.current().nextInt();
        int shardId = ThreadLocalRandom.current().nextInt();

        DeletedShardSet set = new DeletedShardSet();
        assertFalse(set.contains(projectId, shardId));

        set.add(projectId, shardId);
        assertTrue(set.contains(projectId, shardId));
    }

    @Test
    public void addMultiple() {
        DeletedShardSet set = new DeletedShardSet();
        int projectId = 1;
        for (int index = 1; index < 10; index++) {
            assertFalse(set.contains(projectId, index));
            set.add(projectId, index);
            assertTrue(set.contains(projectId, index));
        }

        for (int index = 1; index < 10; index++) {
            assertTrue(set.contains(projectId, index));
        }
    }

    @Test
    public void empty() {
        DeletedShardSet set = new DeletedShardSet();
        assertTrue(set.isEmpty());
        set.add(1, 42);
        assertFalse(set.isEmpty());
    }

    @Test
    public void addFromAnother() {
        DeletedShardSet one = new DeletedShardSet();
        one.add(1, 42);
        assertTrue(one.contains(1, 42));
        assertFalse(one.contains(1, 43));

        DeletedShardSet two = new DeletedShardSet();
        two.add(1, 43);
        two.add(1, 44);
        assertTrue(two.contains(1, 43));
        assertTrue(two.contains(1, 44));

        DeletedShardSet tree = new DeletedShardSet();
        tree.addAll(one);
        tree.addAll(two);

        assertTrue(tree.contains(1, 42));
        assertTrue(tree.contains(1, 43));
        assertTrue(tree.contains(1, 44));
    }

    @Test
    public void iterate() {
        DeletedShardSet set = new DeletedShardSet();
        assertFalse(set.iterator().hasNext());

        set.add(1, 2);
        var it = set.iterator();
        assertTrue(it.hasNext());
        var shard = it.next();
        assertEquals(1, shard.projectId);
        assertEquals(2, shard.shardId);
        assertFalse(it.hasNext());
    }
}
