package ru.yandex.stockpile.server.data.command;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.DeletedShardSet;

import static org.junit.Assert.assertEquals;
import static org.junit.Assume.assumeTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class LongFileTypeSnapshotCommandTest {

    @Before
    public void setUp() throws Exception {
        assumeTrue("Unsupported format", StockpileFormat.CURRENT.ge(StockpileFormat.DELETED_SHARDS_39));
    }

    @Test
    public void serializeDeserializeDeletedShards() {
        var deletedShards = new DeletedShardSet();
        deletedShards.add(1, 3);
        deletedShards.add(1, 145);
        var content = new SnapshotCommandContent(deletedShards);
        var expected = new SnapshotCommand(SnapshotLevel.DAILY, 42, content);

        var result = deserialize(serialize(expected));
        assertEquals(expected, result);
    }

    public SnapshotCommandPartsSerialized serialize(SnapshotCommand command) {
        return LongFileTypeSnapshotCommand.I.serialize(command);
    }

    private SnapshotCommand deserialize(SnapshotCommandPartsSerialized serialized) {
        var key = LongFileTypeSnapshotCommand.I.serializedPartsGetKey(serialized);
        var content = LongFileTypeSnapshotCommand.I.serializer().deserializeParts(serialized.getContent());
        return new SnapshotCommand(key.level(), key.txn(), content);
    }
}
