package ru.yandex.stockpile.server.data.dao;

import java.util.Optional;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.inMem.KikimrKvClientInMem;
import ru.yandex.kikimr.proto.MsgbusKv.TKeyValueRequest.EPriority;
import ru.yandex.kikimr.proto.MsgbusKv.TKeyValueRequest.EStorageChannel;
import ru.yandex.misc.random.Random2;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.stockpile.kikimrKv.counting.KikimrKvClientCounting;
import ru.yandex.stockpile.kikimrKv.counting.KikimrKvClientMetrics;
import ru.yandex.stockpile.kikimrKv.counting.ReadClass;
import ru.yandex.stockpile.kikimrKv.counting.WriteClass;


/**
 * @author Sergey Polovko
 */
public class LargeFileWriterTest {

    private KikimrKvClientCounting kvClient;
    private LargeFileWriter writer;
    private long tabletId;
    private long gen;

    @Before
    public void setUp() {
        KikimrKvClientInMem kvClientImpl = new KikimrKvClientInMem();
        tabletId = kvClientImpl.createKvTablet();

        gen = kvClientImpl.incrementGeneration(tabletId, 0).join();

        kvClient = new KikimrKvClientCounting(kvClientImpl, new KikimrKvClientMetrics(new MetricRegistry()));
        writer = new LargeFileWriter(kvClient, tabletId, gen, WriteClass.LOG, EStorageChannel.MAIN, EPriority.REALTIME);
    }

    @Test
    public void emptyFile() {
        writer.write("emptyFile", new byte[]{}).join();
        byte[] content = read("emptyFile");
        Assert.assertArrayEquals(new byte[]{}, content);
    }

    @Test
    public void smallFile() {
        {
            writer.write("smallFile1", new byte[]{ 0x42 }).join();
            byte[] content = read("smallFile1");
            Assert.assertArrayEquals(new byte[]{ 0x42 }, content);
        }
        {
            byte[] content = new byte[KikimrKvClient.DO_NOT_EXCEED_FILE_SIZE - 1];
            Random2.threadLocal().nextBytes(content);

            writer.write("smallFile2", content).join();
            byte[] read = read("smallFile2");
            Assert.assertArrayEquals(content, read);
        }
    }

    @Test
    public void largeFile() {
        byte[] content = new byte[KikimrKvClient.DO_NOT_EXCEED_FILE_SIZE + 1];
        Random2.threadLocal().nextBytes(content);

        writer.write("largeFile", content).join();
        byte[] read = read("largeFile");
        Assert.assertArrayEquals(content, read);
    }

    private byte[] read(String name) {
        Optional<byte[]> content = kvClient.readData(ReadClass.OTHER, tabletId, gen, name).join();
        Assert.assertTrue(content.isPresent());
        return content.get();
    }
}
