package ru.yandex.stockpile.server.data.index;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.stockpile.server.data.index.stats.IndexStatsData;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class DataStatsTest {

    @Test
    public void objectSize() {
        IndexStatsData stats = new IndexStatsData();
        assertEquals(expectedLayout(stats), stats.memorySizeIncludingSelf());
    }

    private long expectedLayout(IndexStatsData source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        System.out.println(gl.toFootprint());
        return gl.totalSize();
    }
}
