package ru.yandex.stockpile.server.data.index;

import java.util.stream.IntStream;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.data.chunk.ChunkIndex;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotIndexContentTest {
    @Test
    public void objectSizeEmpty() {
        SnapshotIndexContent source = new SnapshotIndexContent();
        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf(), 30);
    }

    @Test
    public void objectSize() {
        SnapshotIndexProperties properties = new SnapshotIndexProperties()
            .setCreatedAt(System.currentTimeMillis());

        ChunkIndex[] chunks = IntStream.range(0, 43)
            .mapToObj(chunkNo -> new ChunkIndex(123))
            .toArray(ChunkIndex[]::new);

        SnapshotIndexContent source = new SnapshotIndexContent(StockpileFormat.CURRENT, properties, chunks);
        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf());
    }

    private long expectedLayout(SnapshotIndexContent source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        long enums = GraphLayout.parseInstance(source.snapshotReason, source.format).totalSize();
        return gl.totalSize() - enums;
    }
}
