package ru.yandex.stockpile.server.data.index;

import com.google.protobuf.ByteString;
import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.stockpile.server.SnapshotLevel;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotIndexPartsSerializedTest {

    @Test
    public void objectSizeEmpty() {
        SnapshotIndexPartsSerialized source = new SnapshotIndexPartsSerialized(SnapshotLevel.TWO_HOURS, 42, new ByteString[0]);
        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf());
    }

    @Test
    public void objectSize() {
        SnapshotIndexPartsSerialized source = new SnapshotIndexPartsSerialized(SnapshotLevel.TWO_HOURS, 42,
            new ByteString[]{
                ByteString.copyFrom(new byte[1002])
        });

        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf());
    }

    private long expectedLayout(SnapshotIndexPartsSerialized source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        long enums = GraphLayout.parseInstance(SnapshotLevel.TWO_HOURS).totalSize();
        return gl.totalSize() - enums;
    }
}
