package ru.yandex.stockpile.server.data.index;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.shard.SnapshotReason;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotIndexTest {

    @Test
    public void objectSize() {
        SnapshotIndex source = new SnapshotIndex(
            SnapshotLevel.DAILY,
            42,
            new SnapshotIndexContent());

        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf(), 50);
    }

    private long expectedLayout(SnapshotIndex source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        long enums = GraphLayout.parseInstance(
            SnapshotReason.UNKNOWN,
            StockpileFormat.CURRENT,
            SnapshotLevel.DAILY)
            .totalSize();
        return gl.totalSize() - enums;
    }
}
