package ru.yandex.stockpile.server.data.log;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.codec.serializer.HeapStockpileSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;

/**
 * @author Sergey Polovko
 */
public class StockpileLogEntryPropertiesSerializerTest {

    private static final StockpileLogEntryPropertiesSerializer newSer = new StockpileLogEntryPropertiesSerializer.V2();

    @Test
    public void fromNewToNew() throws Exception {
        StockpileLogEntryProperties propsBefore = new StockpileLogEntryProperties(555);

        var serializer = new HeapStockpileSerializer();
        newSer.serializeWithLength(propsBefore, serializer);

        StockpileDeserializer deserializer = new StockpileDeserializer(serializer.build());
        StockpileLogEntryProperties propsAfter = newSer.deserializeWithLength(deserializer);
        Assert.assertTrue(deserializer.atEof());

        Assert.assertEquals(propsBefore.getArchivesCount(), propsAfter.getArchivesCount());
    }
}
