package ru.yandex.stockpile.server.data.log;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileLogEntrySerializedTest {

    @Test
    public void objectSizeEmpty() {
        StockpileLogEntrySerialized serialized = new StockpileLogEntrySerialized(1, new byte[0]);

        GraphLayout gl = GraphLayout.parseInstance(serialized);
        assertEquals(gl.totalSize(), serialized.memorySizeIncludingSelf(), 8);
    }

    @Test
    public void objectSize() {
        StockpileLogEntrySerialized serialized = new StockpileLogEntrySerialized(1, new byte[123]);

        GraphLayout gl = GraphLayout.parseInstance(serialized);
        assertEquals(gl.totalSize(), serialized.memorySizeIncludingSelf(), 8);
    }
}
