package ru.yandex.stockpile.server.data.log;

import java.util.concurrent.ThreadLocalRandom;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.codec.serializer.StockpileFormat;

/**
 * @author Vladimir Gordiychuk
 */
@RunWith(Parameterized.class)
public class StockpileProducerSeqNoSnapshotSerializerTest {
    @Parameterized.Parameter
    public StockpileFormat format;

    @Parameterized.Parameters(name = "{0}")
    public static Object[] data() {
        return StockpileFormat.values();
    }

    @Test
    public void serializeDeserialize() {
        var expected = randomProducerSeqNo();
        var actual = deserialize(serialize(expected));
        Assert.assertEquals(expected, actual);
    }

    public byte[] serialize(Int2LongMap snapshot) {
        return new StockpileProducerSeqNoSnapshotSerializer(format).serializeToBytes(snapshot);
    }

    private Int2LongMap deserialize(byte[] serialized) {
        return StockpileProducerSeqNoSnapshotSerializer.S.deserializeFull(serialized);
    }

    private Int2LongMap randomProducerSeqNo() {
        var random = ThreadLocalRandom.current();
        int count = random.nextInt(0,10_000);
        Int2LongMap result = new Int2LongOpenHashMap(count);
        for (int index = 0; index < count; index++) {
            int producerId = random.nextInt();
            long producerSeqNo = random.nextLong();
            result.put(producerId, producerSeqNo);
        }
        return result;
    }
}
