package ru.yandex.stockpile.server.data.names;

import org.junit.Test;

import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.names.file.ChunkFile;
import ru.yandex.stockpile.server.data.names.file.CommandFile;
import ru.yandex.stockpile.server.data.names.file.IndexFile;
import ru.yandex.stockpile.server.data.names.file.LogFile;
import ru.yandex.stockpile.server.data.names.parserFormatter.ParserFormatter;

import static org.junit.Assert.assertEquals;

/**
 * @author Stepan Koltsov
 */
public class FileNameParsedTest {

    private <A extends FileNameParsed> void testPf(String s, A expected, ParserFormatter<A> pf) {
        assertEquals(s, pf.format(expected));
        assertEquals(expected, pf.parseOrThrow(s));
        assertEquals(expected, FileNameParsed.parseCurrent(StockpileKvNames.CURRENT_PREFIX + s));
    }

    @Test
    public void newFormat() {
        testPf("i0.00000000005814833.00034y", new IndexFile(SnapshotLevel.TWO_HOURS, 5814833, 34, false), IndexFile.pf);
        testPf("i0.00000000005814833.00035z", new IndexFile(SnapshotLevel.TWO_HOURS, 5814833, 35, true), IndexFile.pf);
        testPf("i2.00000000005807016.00000z", new IndexFile(SnapshotLevel.ETERNITY, 5807016, 0, true), IndexFile.pf);
        testPf("s0.00000000005869650.00002", new ChunkFile(SnapshotLevel.TWO_HOURS, 5869650, 2), ChunkFile.pf);
        testPf("s1.00000000005807016.00017", new ChunkFile(SnapshotLevel.DAILY, 5807016, 17), ChunkFile.pf);
        testPf("l.00000000005869750.00023y", new LogFile(5869750, 23, false), LogFile.pf);
        testPf("l.00000000005869750.00024z", new LogFile(5869750, 24, true), LogFile.pf);

        testPf("c0.00000000005814833.00034y", new CommandFile(SnapshotLevel.TWO_HOURS, 5814833, 34, false), CommandFile.pf);
        testPf("c0.00000000005814833.00035z", new CommandFile(SnapshotLevel.TWO_HOURS, 5814833, 35, true), CommandFile.pf);
        testPf("c1.00000000005814833.00001z", new CommandFile(SnapshotLevel.DAILY, 5814833, 1, true), CommandFile.pf);
        testPf("c2.00000000005814833.00001z", new CommandFile(SnapshotLevel.ETERNITY, 5814833, 1, true), CommandFile.pf);
    }

}
