package ru.yandex.stockpile.server.data.names;

import java.time.Instant;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class FileNamePrefixTest {

    @Test
    public void backupBf() {
        long instantSeconds = Instant.parse("2016-03-22T23:45:49Z").getEpochSecond();

        String format = FileNamePrefix.Backup.pf.format(new FileNamePrefix.Backup(instantSeconds));
        Assert.assertEquals("b20160322T234549.", format);
        Assert.assertEquals(instantSeconds, FileNamePrefix.Backup.pf.parseOrThrow(format).getInstantSeconds());
    }

}
