package ru.yandex.stockpile.server.data.names;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class NumberNamePartTest {

    @Test
    public void max() {
        Assert.assertEquals(9, new NumberNamePart(1).max);
        Assert.assertEquals(999, new NumberNamePart(3).max);
    }

    @Test
    public void format() {
        Assert.assertEquals("0", new NumberNamePart(1).format(0));
        Assert.assertEquals("8", new NumberNamePart(1).format(8));
        Assert.assertEquals("9", new NumberNamePart(1).format(9));
        Assert.assertEquals("000", new NumberNamePart(3).format(0));
        Assert.assertEquals("009", new NumberNamePart(3).format(9));
        Assert.assertEquals("023", new NumberNamePart(3).format(23));
        Assert.assertEquals("999", new NumberNamePart(3).format(999));
    }

}
