package ru.yandex.stockpile.server.data.names.file;

import java.util.Optional;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * @author Vladimir Gordiychuk
 */
public class ProducerSeqNoFileTest {

    @Test
    public void format() {
        assertEquals(ProducerSeqNoFile.FILE_NAME, ProducerSeqNoFile.pf.format(new ProducerSeqNoFile()));
    }

    @Test
    public void parseExact() {
        assertNotNull(ProducerSeqNoFile.pf.parseOrThrow(ProducerSeqNoFile.FILE_NAME));
    }

    @Test
    public void parseInvalidName() {
        assertEquals(Optional.empty(), ProducerSeqNoFile.pf.parse(ProducerSeqNoFile.FILE_NAME + "test"));
    }
}
