package ru.yandex.stockpile.server.shard;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

import org.junit.Test;

import ru.yandex.solomon.util.host.HostUtils;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class KvLockTest {

    @Test
    public void parse() {
        StringBuilder str = new StringBuilder();
        str.append("{")
            .append("\"fqdn\": ").append("\"solomon-dev-myt-00.search.yandex.net\"")
            .append(", \"pid\":").append("42")
            .append(", \"expiredAt\":").append("1563356950")
            .append("}");
        KvLock lock = KvLock.parse(str.toString().getBytes());

        assertEquals("solomon-dev-myt-00.search.yandex.net", lock.host);
        assertEquals(42, lock.pid);
        assertEquals(1563356950, lock.expiredAtSeconds);
    }

    @Test
    public void serialize() {
        KvLock lock = new KvLock();
        lock.host = "solomon-dev-myt-00.search.yandex.net";
        lock.pid = 42;
        lock.expiredAtSeconds = 1563356950L;

        var expected = "{\"fqdn\":\"solomon-dev-myt-00.search.yandex.net\",\"pid\":42,\"expiredAt\":1563356950}";
        var result = new String(KvLock.serialize(lock));
        assertEquals(expected, result);
    }

    @Test
    public void serializeParse() {
        KvLock lock = new KvLock();
        lock.host = HostUtils.getFqdn();
        lock.pid = ThreadLocalRandom.current().nextInt();
        lock.expiredAtSeconds = ThreadLocalRandom.current().nextLong();

        var serialized = KvLock.serialize(lock);
        KvLock parsed = KvLock.parse(serialized);
        assertEquals(lock, parsed);
    }

    @Test
    public void expired() {
        KvLock lock = new KvLock();

        lock.expiredAtSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 15_000);
        assertFalse(lock.isExpired());
        lock.expiredAtSeconds -= 30;
        assertTrue(lock.isExpired());
    }
}
