package ru.yandex.stockpile.server.shard;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;

import org.junit.Test;

import ru.yandex.solomon.util.ExceptionUtils;

/**
 * @author Stepan Koltsov
 */
public class MergeProcessTest {

    @Test
    public void forkJoinPoolExceptionHandlerFires() throws InterruptedException {
        CountDownLatch fired = new CountDownLatch(1);

        RuntimeException ex = new RuntimeException();

        ForkJoinPool forkJoinPool = new ForkJoinPool(1, ForkJoinPool.defaultForkJoinWorkerThreadFactory, (r, x) -> {
            if (x != ex) {
                ExceptionUtils.uncaughtException(x);
            }
            fired.countDown();
        }, false);

        forkJoinPool.execute(() -> {
            throw ex;
        });

        fired.await();
    }

}
