package ru.yandex.stockpile.server.shard;

import org.junit.Test;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;
import static ru.yandex.solomon.model.point.AggrPoints.dhistogram;
import static ru.yandex.solomon.model.point.AggrPoints.point;
import static ru.yandex.solomon.util.CloseableUtils.close;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricArchivesTest {
    @Test
    public void append() {
        final long ts0 = System.currentTimeMillis();
        final long step = 10_000;

        MetricArchiveMutable target = new MetricArchiveMutable();
        target.setType(MetricType.DGAUGE);
        target.addRecord(point(ts0, 42.0));

        MetricArchiveMutable update = new MetricArchiveMutable();
        update.setDecimPolicyId((short) 1);
        update.setOwnerShardId(22);
        update.setOwnerProjectId(2);
        update.setType(MetricType.DGAUGE);
        update.addRecord(point(ts0 + step, 32.0));

        AggrGraphDataArrayList expeted = AggrGraphDataArrayList.of(
                point(ts0, 42.0),
                point(ts0 + step, 32.0));

        MetricArchives.typeSafeAppend(1, 2, target, update);
        assertEquals(update.header(), target.header());
        assertEquals(expeted, target.toAggrGraphDataArrayList());
        close(target, update);
    }

    @Test
    public void appendOnlyHeaders() {
        final long ts0 = System.currentTimeMillis();
        final long step = 10_000;

        MetricArchiveMutable target = new MetricArchiveMutable();
        target.setType(MetricType.DGAUGE);
        target.addRecord(point(ts0, 42.0));

        MetricArchiveMutable update = new MetricArchiveMutable();
        update.setDecimPolicyId((short) 1);
        update.setOwnerShardId(22);
        update.setOwnerProjectId(2);
        update.setType(MetricType.HIST_RATE);
        update.addRecord(point(ts0 + step, dhistogram(new double[]{100, 200, 300}, new long[]{5, 0, 1})));

        MetricArchiveMutable expected = new MetricArchiveMutable();
        expected.setType(MetricType.DGAUGE);
        expected.setDecimPolicyId((short) 1);
        expected.setOwnerShardId(22);
        expected.setOwnerProjectId(2);
        expected.addRecord(point(ts0, 42.0));

        MetricArchives.typeSafeAppend(1, 2, target, update);
        assertEquals(expected.header(), target.header());
        assertEquals(expected.toAggrGraphDataArrayList(), target.toAggrGraphDataArrayList());
        close(target, update, expected);
    }

    @Test
    public void appendToEmpty() {
        final long ts0 = System.currentTimeMillis();
        final long step = 10_000;

        MetricArchiveMutable target = new MetricArchiveMutable();

        MetricArchiveMutable update = new MetricArchiveMutable();
        update.setDecimPolicyId((short) 1);
        update.setOwnerShardId(22);
        update.setOwnerProjectId(2);
        update.setType(MetricType.HIST_RATE);
        update.addRecord(point(ts0 + step, dhistogram(new double[]{100, 200, 300}, new long[]{5, 0, 1})));

        MetricArchives.typeSafeAppend(1, 2, target, update);
        assertEquals(update.header(), target.header());
        assertEquals(update.toAggrGraphDataArrayList(), target.toAggrGraphDataArrayList());
        close(target, update);
    }

    @Test
    public void appendOneDGauge() {
        MetricArchiveMutable target = new MetricArchiveMutable();

        MetricArchiveMutable update = new MetricArchiveMutable();
        update.setType(MetricType.DGAUGE);
        update.addRecord(randomPoint(update.getType()));

        MetricArchives.typeSafeAppend(1, 2, target, update);
        assertEquals(update.toAggrGraphDataArrayList(), target.toAggrGraphDataArrayList());
        close(target, update);
    }

    @Test
    public void appendOneDGaugeCopy() {
        MetricArchiveMutable target = new MetricArchiveMutable();

        MetricArchiveMutable update = new MetricArchiveMutable();
        update.setType(MetricType.DGAUGE);
        update.addRecord(randomPoint(update.getType()));

        MetricArchives.typeSafeAppend(1, 2, target, update.clone());
        assertEquals(update.toAggrGraphDataArrayList(), target.toAggrGraphDataArrayList());
        close(target, update);
    }
}
