package ru.yandex.stockpile.server.shard;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Vladimir Gordiychuk
 */
public class SlowConsumer<T> implements Flow.Subscriber<T> {
    private static final Logger logger = LoggerFactory.getLogger(SlowConsumer.class);

    final AtomicLong consumed = new AtomicLong();
    AtomicReference<CountDownLatch> sync = new AtomicReference<>(new CountDownLatch(1));
    final CountDownLatch subscribeSync = new CountDownLatch(1);
    final int requestOnSubscribe;
    volatile Flow.Subscription subscription;

    public SlowConsumer(int requestOnSubscribe) {
        this.requestOnSubscribe = requestOnSubscribe;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscribeSync.countDown();
        if (requestOnSubscribe > 0) {
            subscription.request(requestOnSubscribe);
        }
    }

    @Override
    public void onNext(T item) {
        logger.debug("consumer receive merged: {}", consumed.incrementAndGet());
        var copy = sync.getAndSet(new CountDownLatch(1));
        copy.countDown();
    }

    public void awaitNext() throws InterruptedException {
        subscribeSync.await();
        var copy = sync.get();
        logger.debug("consumer request one more, total consumed {}", consumed.get());
        subscription.request(1);
        copy.await();
    }

    @Override
    public void onError(Throwable e) {
        e.printStackTrace();
    }

    @Override
    public void onComplete() {
    }
}
