package ru.yandex.stockpile.server.shard;

import java.time.Instant;

import org.junit.Test;

import ru.yandex.stockpile.server.shard.SnapshotAndMergeScheduler.MergeCandidate;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.comparesEqualTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.lessThan;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotAndMergeSchedulerTest {

    @Test
    public void sameMergeCandidate() {
        long now = System.currentTimeMillis();
        var left = new MergeCandidate(null, 10, now);
        var right = new MergeCandidate(null, 10, now);

        assertThat(left, comparesEqualTo(right));
    }

    @Test
    public void diffSnapshotCountMergeCandidate() {
        var now = System.currentTimeMillis();
        var left = new MergeCandidate(null, 15, now);
        var right = new MergeCandidate(null, 2, now);

        assertThat(left, greaterThan(right));
        assertThat(right, lessThan(left));
    }

    @Test
    public void snapshotCountHaveMorePriority() {
        {
            var now = timeMillis("2021-03-16T12:31:20Z");
            var left = new MergeCandidate(null, 15, now + 100);
            var right = new MergeCandidate(null, 2, now - 100);

            assertThat(left, greaterThan(right));
            assertThat(right, lessThan(left));
        }
        {
            var now = timeMillis("2021-03-16T12:31:20Z");
            var left = new MergeCandidate(null, 15, now - 100);
            var right = new MergeCandidate(null, 2, now + 100);

            assertThat(left, greaterThan(right));
            assertThat(right, lessThan(left));
        }
    }

    @Test
    public void diffSnapshotAgeMergeCandidate() {
        var left = new MergeCandidate(null, 5, timeMillis("2021-03-16T10:31:20Z"));
        var right = new MergeCandidate(null, 5, timeMillis("2021-03-16T12:31:20Z"));

        assertThat(left, greaterThan(right));
        assertThat(right, lessThan(left));
    }

    @Test
    public void dayAgeHaveMorePriorityMergeCandidate() {
        var left = new MergeCandidate(null, 1, timeMillis("2021-03-14T10:00:00Z"));
        var right = new MergeCandidate(null, 15, timeMillis("2021-03-16T12:31:20Z"));

        assertThat(left, greaterThan(right));
        assertThat(right, lessThan(left));
    }

    private static long timeMillis(String time) {
        return Instant.parse(time).toEpochMilli();
    }
}
