package ru.yandex.stockpile.server.shard;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.command.SnapshotCommand;
import ru.yandex.stockpile.server.data.command.SnapshotCommandContent;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotCommandLoaderStub implements SnapshotCommandLoader {
    private final ConcurrentMap<SnapshotAddress, SnapshotCommand> map = new ConcurrentHashMap<>();

    public void add(SnapshotAddress address, SnapshotCommandContent content) {
        map.put(address, new SnapshotCommand(address.level(), address.txn(), content));
    }

    @Override
    public CompletableFuture<Optional<SnapshotCommand>> readSnapshot(SnapshotAddress address) {
        return CompletableFuture.supplyAsync(() -> {
            return Optional.ofNullable(map.get(address));
        });
    }
}
