package ru.yandex.stockpile.server.shard;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.DeletedShardSet;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.command.SnapshotCommandContent;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotCommandMergerTest {

    private SnapshotCommandMerger merger;
    private SnapshotCommandLoaderStub loader;

    @Before
    public void setUp() throws Exception {
        loader = new SnapshotCommandLoaderStub();
        merger = new SnapshotCommandMerger(loader);
    }

    @Test
    public void empty() {
        var result = merger.merge(List.of()).join();
        assertTrue(result.isEmpty());
    }

    @Test
    public void one() {
        var content = randomCommandContent();
        var address = new SnapshotAddress(SnapshotLevel.TWO_HOURS, 1);
        loader.add(address, content);
        var merged = merger.merge(List.of(address)).join();
        assertEquals(content.deletedShards(), merged.deletedShards());
    }

    @Test
    public void few() {
        DeletedShardSet expected = new DeletedShardSet();
        expected.add(1, 1);
        expected.add(1, 2);

        final SnapshotAddress one = new SnapshotAddress(SnapshotLevel.TWO_HOURS, 1);
        {
            var deletedShards = new DeletedShardSet();
            deletedShards.add(1, 1);
            loader.add(one, new SnapshotCommandContent(deletedShards));
        }

        final SnapshotAddress two = new SnapshotAddress(SnapshotLevel.TWO_HOURS, 2);
        final SnapshotAddress tree = new SnapshotAddress(SnapshotLevel.TWO_HOURS, 3);
        {
            var deletedShards = new DeletedShardSet();
            deletedShards.add(1, 2);
            loader.add(tree, new SnapshotCommandContent(deletedShards));
        }

        var merged = merger.merge(List.of(one, two, tree)).join();
        assertFalse(merged.isEmpty());
        assertEquals(expected, merged.deletedShards());
    }

    private SnapshotCommandContent randomCommandContent() {
        return new SnapshotCommandContent(randomDeletedShards());
    }

    private DeletedShardSet randomDeletedShards() {
        var result = new DeletedShardSet();
        var random = ThreadLocalRandom.current();
        int count = random.nextInt(1, 10);
        for (int index = 0; index < count; index++) {
            result.add(random.nextInt(1, 3), random.nextInt());
        }
        return result;
    }
}
