package ru.yandex.stockpile.server.shard;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;
import ru.yandex.stockpile.server.data.index.SnapshotIndexContent;
import ru.yandex.stockpile.server.shard.stat.LevelSizeAndCount;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotIndexWithStatsTest {

    @Test
    public void objectSize() {
        SnapshotIndexWithStats source = new SnapshotIndexWithStats(new SnapshotIndex(
            SnapshotLevel.DAILY,
            42,
            new SnapshotIndexContent()),
            LevelSizeAndCount.zero);

        assertEquals(expectedLayout(source), source.memorySizeIncludingSelf(), 50);
    }

    private long expectedLayout(SnapshotIndexWithStats source) {
        GraphLayout gl = GraphLayout.parseInstance(source);
        long enums = GraphLayout.parseInstance(
            SnapshotReason.UNKNOWN,
            StockpileFormat.CURRENT,
            SnapshotLevel.DAILY)
            .totalSize();
        return gl.totalSize() - enums;
    }
}
