package ru.yandex.stockpile.server.shard;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.stockpile.client.shard.StockpileShardId;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileLocalShardsTest {

    private StockpileLocalShards shards;

    @Before
    public void setUp() {
        shards = new StockpileLocalShards();
    }

    @Test
    public void getNoExist() {
        for (int shardId = StockpileShardId.FIRST_SHARD_ID; shardId <= 5_000; shardId++) {
            assertNull(StockpileShardId.toString(shardId), shards.getShardById(shardId));
        }
    }

    @Test
    public void emptyStream() {
        var result = shards.stream().collect(Collectors.toList());
        assertEquals(List.of(), result);
    }

    @Test
    public void emptyIterator() {
        var it = shards.iterator();
        assertFalse(it.hasNext());

        try {
            StockpileShard shard = it.next();
            fail("next: " + shard);
        } catch (NoSuchElementException e) {
            // ok
        }
    }

    @Test
    public void emptyForEach() {
        shards.forEach(shard -> {
            fail("should not be called");
        });
    }
}
