package ru.yandex.stockpile.server.shard;

import java.util.concurrent.CompletableFuture;

import org.junit.Test;
import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;
import ru.yandex.stockpile.server.Txn;
import ru.yandex.stockpile.tool.BitBufAssume;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileWriteRequestTest {

    @Test
    public void objectSizeEmpty() {
        BitBufAssume.assumeUsedClass(HeapBitBuf.class);
        CompletableFuture<Txn> future = new CompletableFuture<>();
        StockpileWriteRequest request = StockpileWriteRequest.newBuilder().build();
        assertEquals(expectedLayout(request), request.memorySizeIncludingSelf());
    }

    @Test
    public void objectSize() {
        BitBufAssume.assumeUsedClass(HeapBitBuf.class);
        StockpileWriteRequest request = StockpileWriteRequest.newBuilder()
                .addArchive(1L, MetricArchiveMutable.of(AggrGraphDataArrayList.of(randomPoint(MetricType.DGAUGE))))
                .addArchive(2L, MetricArchiveMutable.of(AggrGraphDataArrayList.of(randomPoint(MetricType.DGAUGE))))
                .addArchive(3L, MetricArchiveMutable.of(AggrGraphDataArrayList.of(randomPoint(MetricType.DGAUGE))))
                .build();
        assertEquals(expectedLayout(request), request.memorySizeIncludingSelf());
    }

    private long expectedLayout(MemMeasurable source) {
        GraphLayout gl = GraphLayout.parseInstance(StockpileFormat.CURRENT, MetricType.DGAUGE, source);
        long enums = GraphLayout.parseInstance(StockpileFormat.CURRENT, MetricType.DGAUGE).totalSize();
        return gl.totalSize() - enums;
    }
}
