package ru.yandex.stockpile.server.shard.load;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.solomon.util.concurrent.CountDownCallback;


/**
 * @author Sergey Polovko
 */
final class CountDownAwait extends CountDownCallback {

    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Throwable> throwable = new AtomicReference<>(null);

    CountDownAwait(int count) {
        super(count);
    }

    @Override
    protected void onComplete() {
        latch.countDown();
    }

    @Override
    public void onFailure(Throwable t) {
        if (throwable.compareAndSet(null, t)) {
            // for lack of countDown(n) method we simply loop over
            while (latch.getCount() > 0) {
                latch.countDown();
            }
        }
    }

    void await() {
        try {
            latch.await();

            Throwable t = throwable.get();
            if (t != null) {
                throw new RuntimeException(t);
            }
        } catch (InterruptedException e) {
            throw ExceptionUtils.throwException(e);
        }
    }
}
