package ru.yandex.stockpile.server.shard.merge;

import org.junit.Test;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static ru.yandex.solomon.model.point.AggrPointDataTestSupport.randomPoint;
import static ru.yandex.solomon.util.CloseableUtils.close;
import static ru.yandex.stockpile.server.shard.merge.Utils.writeUntilCloseFrame;

/**
 * @author Vladimir Gordiychuk
 */
public class AggrPointIteratorWrapperTest {

    @Test
    public void empty() {
        AggrPoint point = new AggrPoint();
        var it = iterator(archive());
        assertFalse(it.next(point));
        assertFalse(it.next(point));
        assertFalse(it.next(point));
    }

    @Test
    public void unclosedFrame() {
        var expected = randomPoint(MetricType.DGAUGE);
        var archive = archive();
        archive.addRecord(expected);

        var it = iterator(archive);

        var actual = new AggrPoint();
        assertTrue(it.next(actual));
        assertEquals(expected, actual);
        assertFalse(it.next(actual));
        assertFalse(it.next(actual));
        assertFalse(it.next(actual));
        close(archive);
    }

    @Test
    public void multipleFrames() {
        var archive = archive();
        writeUntilCloseFrame(archive);
        writeUntilCloseFrame(archive);
        writeUntilCloseFrame(archive);

        var it = iterator(archive);
        assertEquals(it.columnSetMask(), archive.columnSetMask());
        assertEquals(it.estimatePointsCount(), archive.getRecordCount());
        MetricsMatcher.assertEqualTo(archive, it);
        close(archive);
    }

    private MetricArchiveMutable archive() {
        return Utils.archive(StockpileFormat.CURRENT);
    }

    private AggrGraphDataListIterator iterator(MetricArchiveMutable archive) {
        return new AggrPointIteratorWrapper(ArchiveItemIterator.of(archive));
    }
}
